package mole.entities.controlers
{
	import mole.entities.items.IItem;
	import mole.entities.CPlayer;
	import net.flashpunk.FP;
	import net.flashpunk.utils.Input;
	import net.flashpunk.utils.Key;
	
	/**
	 * Controlleur d'un joueur humain.
	 * @author Cédric Liaudet
	 */
	public class CPlayerControler3 implements IControler
	{		
		/**
		 * Constructeur par défaut.
		 */
		public function CPlayerControler3() 
		{			
			// Déplacements
			Input.define("jump3", Key.X);
			Input.define("down3", Key.C);
		}
		
		/**
		 * Callback de mise à jours du controlleur.
		 */
		public function update(_Player:CPlayer):void
		{
			// Saut
			if (Input.pressed("jump3"))
			{
				_Player.OnJump();
			}
			else if (Input.released("jump3"))
			{
				_Player.ReleaseJump();
			}
			
			// Accroupie.
			if (Input.pressed("down3"))
			{
				_Player.OnDown();
			}
			else if (Input.released("down3"))
			{
				_Player.OnUp();
			}
		}
		
		/**
		 * Renvoie la vitesse du controlleur.
		 * @return La vitesse du controlleur.
		 */
		public function GetSpeed():int
		{
			return 0;
		}
	}

}